
class Dir



  # Liste tous les fichiers et dossiers d'un dossier spcifi
  # 
  #  path : chemin de dpart
  #  rec : rcursif ou non
  #  absolu : pour renvoyer le chemin absolu au lieu du relatif
  #
  # Renvoie les chemins relatifs ou absolus
  #
  def self.dirs_files(path, rec=false, absolu=false)

    begin
      liste_d = Dir.entries(path)
    rescue Errno::ENOENT
      raise(DAE_No_Dir.new(path))
    end
    
    liste_f = []

    # On supprime le "." et le ".."
    liste_d -= [".", ".."]

    i = 0
    while i < liste_d.size
      if File.directory?(File.join(path, liste_d.at(i))) == false
        liste_f << liste_d.delete_at(i)
        next
      end
      i += 1
    end

    

    if rec == true and liste_d != []
      temp_dirs = []
      temp_files = []
      for d in liste_d
        pat = File.join(path, d)
        dirs, files = self.dirs_files(pat, true, false)
        dirs.collect!{|x| x = File.join(d, x)}
        files.collect!{|x| x = File.join(d, x)}
        temp_dirs.concat(dirs)
        temp_files.concat(files)
      end
      liste_d.concat(temp_dirs)
      liste_f.concat(temp_files)
      #return liste_d, liste_f
    end


    # On regarde si on doit renvoyer les chemins relatifs ou absolus
    if absolu == true
      # On cre des chemins absolus
      liste_d.collect!{|x| x = File.realpath(path.join(x))}
      liste_f.collect!{|x| x = File.realpath(path.join(x))}
    end

    return liste_d, liste_f
  end

  # Liste tous les dossiers d'un dossier spcifi
  def self.dirs(path, rec=false, absolu=false)
    dirs, files = self.dirs_files(path, rec, absolu)
    return dirs
  end

  # Liste tous les fichiers d'un dossier spcifi
  def self.files(path, rec=false, absolu=false)
    dirs, files = self.dirs_files(path, rec, absolu)
    return files
  end


  # Liste les fichiers et dossiers d'un dossier spcifi
  #  path : le chemin du dossier spcifi
  #  reg_d : seuls les dossiers dont le nom correspond  la regexp seront gards
  #  reg_f : seuls les fichiers dont le nom correspond  la regexp seront gards
  #  recursif : rcursif ou non
  #  absolu : renvoie les noms en chemin absolu ou non
  #
  def self.dirs_files_reg(path, reg_d, reg_f, recursif=false, absolu=false)
    #p "dir", path, reg_d, reg_f
    # On liste les dossiers et fichiers du dossier
    l_d, l_f = Dir::dirs_files(path, recursif, absolu)


    # On slectionne uniquement les dossiers correspondant  la regexp
    l_d.keep_reg_basename(reg_d)

    # On slectionne uniquement les fichiers correspondant  la regexp
    l_f.keep_reg_basename(reg_f)

    #p l_f if l_f.size > 0
    

    # On renvoie les deux listes
    return l_d, l_f

  end



  # Liste les fichiers d'un dossier spcifi
  #  path : le chemin du dossier spcifi
  #  reg_f : seuls les fichiers dont le nom correspond  la regexp seront gards
  #  absolu : renvoie les noms en chemin absolu ou non
  #
  def self.files_reg(path, reg_f, rec=false, absolu=false)

    # On liste les dossiers et fichiers du dossier
    l_f = Dir::files(path, rec, absolu)

    # On slectionne uniquement les fichiers correspondant  la regexp

    l_f.keep_reg_basename(reg_f)

    # On renvoie les deux listes
    return l_f

  end


end
